/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.gp;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.Int;
import org.denom.crypt.blockcipher.AlignMode;
import org.denom.crypt.blockcipher.CryptoMode;
import org.denom.crypt.blockcipher.TripleDES;
import org.denom.format.BerTLV;
import org.denom.format.LV;
import org.denom.smartcard.CApdu;

public class ApduGP {
    public static CApdu GetData(int tag) {
        Ex.MUST(Int.isU16(tag), "Wrong Tag");
        CApdu ap = new CApdu(128, 202, tag >>> 8, tag & 0xFF, Binary.Bin(), 256, "{GP} GET DATA");
        ap.isTlvData = true;
        return ap;
    }

    public static CApdu InstallForLoad(Binary pkgAID, Binary sdAID, Binary capHash) {
        Binary data = LV.LV1(pkgAID, sdAID, capHash, Binary.Bin(), Binary.Bin());
        return new CApdu(128, 230, 2, 0, data, 256, "{GP} INSTALL (for load)");
    }

    public static CApdu InstallForInstall(Binary pkgAID, Binary classAID, Binary instanceAID, Binary appParameters, int privileges, Binary systemParameters) {
        Binary priv = Binary.Num_Bin(privileges, 3);
        if (priv.get(1) == 0 && priv.get(2) == 0) {
            priv = priv.slice(0, 1);
        }
        Binary paramsTagged = BerTLV.Tlv(201, appParameters);
        if (!systemParameters.empty()) {
            paramsTagged.add(BerTLV.Tlv(239, systemParameters));
        }
        Binary data = LV.LV1(pkgAID, classAID, instanceAID, priv, paramsTagged, Binary.Bin());
        return new CApdu(128, 230, 12, 0, data, 256, "{GP} INSTALL (for install)");
    }

    public static CApdu InstallForInstall(Binary pkgAID, Binary classAID, Binary instanceAID, Binary params, int privileges) {
        return ApduGP.InstallForInstall(pkgAID, classAID, instanceAID, params, privileges, Binary.Bin());
    }

    public static CApdu InstallForInstall(String pkgAID, String classAID, String instanceAID, String params, int privileges) {
        return ApduGP.InstallForInstall(Binary.Bin(pkgAID), Binary.Bin(classAID), Binary.Bin(instanceAID), Binary.Bin(params), privileges);
    }

    public static CApdu LoadFirstBlock(int capSize, Binary capPart, Binary dapVal) {
        Binary data = Binary.Bin();
        if (!dapVal.empty()) {
            Binary tlv1 = BerTLV.Tlv(79, Binary.Bin());
            Binary tlv2 = BerTLV.Tlv(195, dapVal);
            data.add(BerTLV.Tlv(226, Binary.Bin(tlv1, tlv2)));
        }
        BerTLV.appendTlvTag(data, 196);
        BerTLV.appendTlvLen(data, capSize);
        data.add(capPart);
        boolean isLastBlock = capSize == capPart.size();
        return new CApdu(128, 232, isLastBlock ? 128 : 0, 0, data, 256, "{GP} LOAD (block 0)");
    }

    public static CApdu LoadNextBlock(int blockNumber, Binary capPart, boolean isLastBlock) {
        int p1 = isLastBlock ? 128 : 0;
        return new CApdu(128, 232, p1, blockNumber & 0xFF, capPart, 256, "{GP} LOAD (block " + blockNumber + ")");
    }

    public static CApdu Delete(Binary aid, int deleteMode) {
        Ex.MUST(Int.isU8(deleteMode), "delete mode must be U8");
        Binary data = BerTLV.Tlv(79, aid);
        CApdu ap = new CApdu(128, 228, 0, deleteMode, data, 256, "{GP} DELETE");
        ap.isTlvData = true;
        return ap;
    }

    public static CApdu Delete(String aid, int deleteMode) {
        return ApduGP.Delete(Binary.Bin(aid), deleteMode);
    }

    public static CApdu GetStatus(int target_P1, Binary aid, boolean isResponseDataNew, boolean isNextOccurrence) {
        Ex.MUST(Int.isU8(target_P1) && (target_P1 & 0xF) == 0, "status target must be U8");
        int p2 = isNextOccurrence ? 1 : 0;
        CApdu ap = new CApdu(128, 242, target_P1, p2 |= isResponseDataNew ? 2 : 0, BerTLV.Tlv(79, aid), 256, "{GP} GET STATUS");
        ap.isTlvData = true;
        return ap;
    }

    public static CApdu SetStatus(int setStatusTarget, int appState, Binary aid) {
        Ex.MUST(Int.isU8(setStatusTarget), "status target must be U8");
        Ex.MUST(Int.isU8(appState), "status must be U8");
        return new CApdu(128, 240, setStatusTarget, appState, aid, 0, "{GP} SET STATUS");
    }

    public static CApdu PutKey(int keyId, int keyType, int keyVersionCurrent, int keyVersionNew, Binary keyVal, Binary dekSessionKey) {
        Ex.MUST(keyId >= 0 && keyId <= 127, "Wrong KeyId");
        Ex.MUST(keyVersionCurrent >= 0 && keyVersionCurrent <= 127, "Wrong keyVersionCurrent");
        Ex.MUST(keyVersionNew >= 0 && keyVersionNew <= 127, "Wrong keyVersionNew");
        Binary data = Binary.Bin().reserve(30);
        data.add(keyVersionNew);
        data.add(ApduGP.Build3DesKeyData(keyType, keyVal, dekSessionKey));
        return new CApdu(128, 216, keyVersionCurrent, keyId, data, 256, "{GP} PUT KEY");
    }

    private static Binary Build3DesKeyData(int keyType, Binary key, Binary dekSessionKey) {
        Binary encryptedKey = dekSessionKey.empty() ? key : new TripleDES(dekSessionKey).encrypt(key, CryptoMode.ECB, AlignMode.NONE, null);
        Binary data = Binary.Bin().reserve(30);
        data.add(keyType);
        data.add(LV.LV1(encryptedKey));
        data.add(LV.LV1(new TripleDES(key).calcKCV()));
        return data;
    }

    public static CApdu PutKey_KeySet(int keyId, int keyType, int keyVersionCurrent, int keyVersionNew, Binary key1, Binary key2, Binary key3, Binary dekSessionKey) {
        Ex.MUST(keyId >= 0 && keyId <= 127, "Wrong KeyId");
        Ex.MUST(keyVersionCurrent >= 0 && keyVersionCurrent <= 127, "Wrong keyVersionCurrent");
        Ex.MUST(keyVersionNew >= 0 && keyVersionNew <= 127, "Wrong keyVersionNew");
        int p2 = 0x80 | keyId;
        Binary data = Binary.Bin().reserve(100);
        data.add(keyVersionNew);
        data.add(ApduGP.Build3DesKeyData(keyType, key1, dekSessionKey));
        data.add(ApduGP.Build3DesKeyData(keyType, key2, dekSessionKey));
        data.add(ApduGP.Build3DesKeyData(keyType, key3, dekSessionKey));
        return new CApdu(128, 216, keyVersionCurrent, p2, data, 256, "{GP} PUT KEY DES3 KeySet");
    }

    public static CApdu InitializeUpdate(Binary challenge, int keyVer) {
        Ex.MUST(Int.isU8(keyVer), "Wrong Key Version");
        return new CApdu(128, 80, keyVer, 0, challenge, 256, "{GP} INITIALIZE UPDATE");
    }

    public static CApdu ExternalAuthenticate(int GP_SecurityLevel, Binary hostCryptogram) {
        Ex.MUST(Int.isU8(GP_SecurityLevel), "security level must be U8");
        return new CApdu(132, 130, GP_SecurityLevel, 0, hostCryptogram, 0, "{GP} EXTERNAL AUTHENTICATE");
    }

    public static CApdu StoreData(int p1, boolean isLastBlock, int blockNumber, boolean isCase4, Binary data) {
        if (isLastBlock) {
            p1 |= 0x80;
        }
        if (isCase4) {
            p1 |= 1;
        }
        return new CApdu(128, 226, p1, blockNumber, data, isCase4 ? 256 : 0, "{GP} STORE DATA");
    }
}

