/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.gp;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.Int;
import org.denom.crypt.blockcipher.AlignMode;
import org.denom.crypt.blockcipher.CryptoMode;
import org.denom.crypt.blockcipher.DES;
import org.denom.crypt.blockcipher.TripleDES;
import org.denom.smartcard.CApdu;
import org.denom.smartcard.CardReader;
import org.denom.smartcard.ISM;
import org.denom.smartcard.RApdu;
import org.denom.smartcard.gp.ApduGP;
import org.denom.smartcard.gp.ISecurityModuleGP;

public class GP_SM
implements ISM {
    public int keysVersion = 0;
    public TripleDES dekCipher = new TripleDES();
    private TripleDES encCipher = new TripleDES();
    private TripleDES cmacCipher = new TripleDES();
    private TripleDES rmacCipher = new TripleDES();
    private int securityLevel;
    private Binary icv = Binary.Bin(8);
    private Binary rmac = Binary.Bin(8);
    private Binary rmacBuf = Binary.Bin();

    public static void DeriveSMKeys(String skdMethod, Binary baseKey, Binary keyDiversData, Binary encKey, Binary macKey, Binary dekKey) {
        Ex.MUST(keyDiversData.size() == 10, "Key Diversification Data size must be 10 bytes");
        Binary data = null;
        if (skdMethod.equalsIgnoreCase("VISA2")) {
            data = keyDiversData.slice(0, 2).add(keyDiversData.slice(4, 4));
        } else if (skdMethod.equalsIgnoreCase("EMV CPS 1.1")) {
            data = keyDiversData.slice(4, 6);
        } else {
            Ex.THROW("Wrong Key Derivation Method");
        }
        TripleDES cipher = new TripleDES(baseKey);
        encKey.assign(cipher.encrypt(Binary.Bin(data, Binary.Bin("F001"), data, Binary.Bin("0F01")), CryptoMode.ECB, AlignMode.NONE, null));
        macKey.assign(cipher.encrypt(Binary.Bin(data, Binary.Bin("F002"), data, Binary.Bin("0F02")), CryptoMode.ECB, AlignMode.NONE, null));
        dekKey.assign(cipher.encrypt(Binary.Bin(data, Binary.Bin("F003"), data, Binary.Bin("0F03")), CryptoMode.ECB, AlignMode.NONE, null));
    }

    public static void DeriveSMKeys_VISA2(Binary baseKey, Binary keyDiversData, Binary encKey, Binary macKey, Binary dekKey) {
        GP_SM.DeriveSMKeys("VISA2", baseKey, keyDiversData, encKey, macKey, dekKey);
    }

    public static void DeriveSMKeys_EMVCPS11(Binary baseKey, Binary keyDiversData, Binary encKey, Binary macKey, Binary dekKey) {
        GP_SM.DeriveSMKeys("EMV CPS 1.1", baseKey, keyDiversData, encKey, macKey, dekKey);
    }

    public GP_SM() {
        this.rmacBuf.reserve(519);
    }

    public void init(SessionKeys keys, int secLevel, Binary icv, int keysVersion) {
        Ex.MUST(Int.isU8(secLevel), "Must be U8");
        this.encCipher.setKey(keys.enc);
        this.cmacCipher.setKey(keys.cmac);
        this.rmacCipher.setKey(keys.rmac);
        this.dekCipher.setKey(keys.dek);
        this.icv.assign(icv);
        this.rmac.assign(icv);
        this.securityLevel = secLevel;
        this.keysVersion = keysVersion;
    }

    @Override
    public CApdu encryptCommand(CApdu noSM) {
        Binary mac = Binary.Bin();
        int logicalChannel = noSM.getLogicalChannel();
        int cleanCla = noSM.clearLogicalChannel();
        if ((this.securityLevel & 0x10) != 0) {
            this.rmacBuf.resize(0);
            this.rmacBuf.add(cleanCla);
            this.rmacBuf.add(noSM.ins);
            this.rmacBuf.add(noSM.p1);
            this.rmacBuf.add(noSM.p2);
            this.rmacBuf.add(Binary.Num_Bin(noSM.Nc(), 0));
            this.rmacBuf.add(noSM.data);
        }
        if ((this.securityLevel & 1) != 0) {
            Binary cmacBuf = Binary.Bin();
            cmacBuf.reserve(5 + noSM.data.size());
            if (logicalChannel > 3) {
                cmacBuf.add(cleanCla | 0x20);
            } else {
                cmacBuf.add(cleanCla | 4);
            }
            cmacBuf.add(noSM.ins);
            cmacBuf.add(noSM.p1);
            cmacBuf.add(noSM.p2);
            cmacBuf.add(Binary.Num_Bin(noSM.Nc() + 8, 0));
            cmacBuf.add(noSM.data);
            DES icv_cipher = new DES(this.cmacCipher.getKey().slice(0, 8));
            Binary icv_encrypted = icv_cipher.encrypt(this.icv, CryptoMode.ECB, AlignMode.NONE, null);
            this.icv = mac = this.cmacCipher.calcMACAlg3(cmacBuf, AlignMode.BLOCK, icv_encrypted);
        }
        Binary data_field = (this.securityLevel & 2) != 0 ? (noSM.data.empty() ? Binary.Bin() : this.encCipher.encrypt(noSM.data, CryptoMode.CBC, AlignMode.BLOCK, null)) : noSM.data.clone();
        if ((this.securityLevel & 1) != 0) {
            data_field.add(mac);
        }
        int Ne = noSM.getNe();
        if ((this.securityLevel & 0x10) != 0) {
            Ne += 8;
        }
        int cla = noSM.cla;
        if (this.securityLevel != 0) {
            cla = logicalChannel > 3 ? (cla |= 0x20) : (cla |= 4);
        }
        CApdu withSM = new CApdu(cla, noSM.ins, noSM.p1, noSM.p2, data_field, Ne);
        return withSM;
    }

    @Override
    public RApdu decryptResponse(RApdu withSM) {
        RApdu noSM = withSM.clone();
        if ((this.securityLevel & 0x10) != 0) {
            Ex.MUST(noSM.response.size() >= 8, "Wrong card answer length");
            int respDataSize = noSM.response.size() - 8;
            this.rmacBuf.add(respDataSize);
            if (respDataSize != 0) {
                this.rmacBuf.add(noSM.response.slice(0, respDataSize));
            }
            this.rmacBuf.addU16(noSM.status);
            if (this.rmac.size() % 8 != 0) {
                this.rmac.add(Binary.Bin(8 - this.rmac.size(), 0));
            }
            Binary rmacCCS = this.rmacCipher.calcMACAlg3(this.rmacBuf, AlignMode.BLOCK, this.rmac);
            Ex.MUST(rmacCCS.equals(noSM.response.slice(respDataSize, 8)), "\u041d\u0435 \u0441\u043e\u0448\u0435\u043b\u0441\u044f R-MAC");
            this.rmac = rmacCCS;
            noSM.response = noSM.response.slice(0, respDataSize);
        }
        return noSM;
    }

    public static Binary CalcGP_Cryptogram(Binary encSessionKey, Binary divData) {
        return new TripleDES(encSessionKey).calcMAC(divData, AlignMode.BLOCK, null);
    }

    public static SessionKeys genSessionKeys(Binary encKey, Binary macKey, Binary dekKey, Binary hostChallenge, Binary gpInitUpdateResponse) {
        Binary keyDiversData = gpInitUpdateResponse.slice(0, 10);
        Binary ssc = gpInitUpdateResponse.slice(12, 2);
        Binary cardChallenge = gpInitUpdateResponse.slice(14, 6);
        Binary cardCryptogram = gpInitUpdateResponse.slice(20, 8);
        SessionKeys sessionKeys = new SessionKeys(encKey, macKey, dekKey, ssc);
        Binary divData = Binary.Bin().add(hostChallenge).add(ssc).add(cardChallenge);
        Binary cryptogram = GP_SM.CalcGP_Cryptogram(sessionKeys.enc, divData);
        if (!cardCryptogram.equals(cryptogram)) {
            sessionKeys = SessionKeys.Derive("EMV CPS 1.1", encKey, keyDiversData, ssc);
            cryptogram = GP_SM.CalcGP_Cryptogram(sessionKeys.enc, divData);
        }
        if (!cardCryptogram.equals(cryptogram)) {
            sessionKeys = SessionKeys.Derive("VISA2", encKey, keyDiversData, ssc);
            cryptogram = GP_SM.CalcGP_Cryptogram(sessionKeys.enc, divData);
        }
        return cardCryptogram.equals(cryptogram) ? sessionKeys : null;
    }

    public static CApdu formExtAuth(Binary cardResponse, int secLevel, Binary hostChallenge, SessionKeys sessionKeys, GP_SM sm) {
        Binary ssc = cardResponse.slice(12, 2);
        Binary cardChallenge = cardResponse.slice(14, 6);
        Binary hostCryptogram = GP_SM.CalcGP_Cryptogram(sessionKeys.enc, Binary.Bin().add(ssc).add(cardChallenge).add(hostChallenge));
        CApdu capdu = ApduGP.ExternalAuthenticate(secLevel, hostCryptogram);
        Binary header = Binary.Bin();
        header.reserve(5);
        header.add(capdu.cla);
        header.add(capdu.ins);
        header.add(capdu.p1);
        header.add(capdu.p2);
        header.add(capdu.Nc() + 8);
        Binary mac = new TripleDES(sessionKeys.cmac).calcMACAlg3(Binary.Bin(header, hostCryptogram), AlignMode.BLOCK, null);
        capdu.data = Binary.Bin(hostCryptogram, mac);
        sm.init(sessionKeys, secLevel, mac, cardResponse.get(10));
        return capdu;
    }

    public static GP_SM open(int keyVersion, Binary encKey, Binary macKey, Binary dekKey, int secLevel, CardReader cr) {
        Ex.MUST(Int.isU8(secLevel), "Must be U8");
        Binary hostChallenge = Binary.Bin().random(8);
        cr.Cmd(ApduGP.InitializeUpdate(hostChallenge, keyVersion));
        SessionKeys sessionKeys = GP_SM.genSessionKeys(encKey, macKey, dekKey, hostChallenge, cr.resp);
        Ex.MUST(sessionKeys != null, "\u041a\u043b\u044e\u0447\u0438 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043a\u0440\u0438\u043f\u0442\u043e\u0433\u0440\u0430\u043c\u043c\u0435 \u043a\u0430\u0440\u0442\u044b");
        GP_SM sm = new GP_SM();
        cr.Cmd(GP_SM.formExtAuth(cr.resp, secLevel, hostChallenge, sessionKeys, sm));
        return sm;
    }

    public static GP_SM open(int keyVersion, Binary baseKey, int secLevel, CardReader cr) {
        return GP_SM.open(keyVersion, baseKey, baseKey, baseKey, secLevel, cr);
    }

    public static GP_SM open(CardReader cr, int keyVersion, int smSecurityLevel, ISecurityModuleGP securityModule) {
        Ex.MUST(Int.isU8(smSecurityLevel), "Must be U8");
        Binary hostChallenge = Binary.Bin().random(8);
        cr.Cmd(ApduGP.InitializeUpdate(hostChallenge, keyVersion));
        int keysVersion = cr.resp.get(10);
        Binary b = securityModule.gpGenSmSessionKeys(smSecurityLevel, hostChallenge, cr.resp);
        Ex.MUST(!b.empty(), "Wrong card cryptogram or incorrect domain keys");
        SessionKeys keys = new SessionKeys();
        keys.enc = b.slice(0, 16);
        keys.cmac = b.slice(16, 16);
        keys.rmac = b.slice(32, 16);
        keys.dek = b.slice(48, 16);
        Binary icv = b.slice(64, 8);
        CApdu capdu = new CApdu(b.slice(72, 21));
        capdu.description = "{GP} EXTERNAL AUTHENTICATE";
        cr.Cmd(capdu);
        GP_SM sm = new GP_SM();
        sm.init(keys, smSecurityLevel, icv, keysVersion);
        return sm;
    }

    public static class SessionKeys {
        public Binary enc = Binary.Bin();
        public Binary cmac = Binary.Bin();
        public Binary rmac = Binary.Bin();
        public Binary dek = Binary.Bin();
        public String skdMethod = "";

        public SessionKeys() {
        }

        public SessionKeys clone() {
            SessionKeys copy = new SessionKeys();
            copy.enc = this.enc.clone();
            copy.cmac = this.cmac.clone();
            copy.rmac = this.rmac.clone();
            copy.dek = this.dek.clone();
            copy.skdMethod = this.skdMethod;
            return copy;
        }

        public SessionKeys(Binary encKey, Binary macKey, Binary dekKey, Binary ssc) {
            Ex.MUST(ssc.size() == 2, "\u0421\u0447\u0451\u0442\u0447\u0438\u043a \u0441\u0435\u0441\u0441\u0438\u0439 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u043c 2 \u0431\u0430\u0439\u0442\u0430");
            Ex.MUST(encKey.size() == 16 && macKey.size() == 16 && dekKey.size() == 16, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u043a\u043b\u044e\u0447\u0430");
            Binary data = Binary.Bin("0101").add(ssc).add(Binary.Bin(12));
            TripleDES cipher = new TripleDES(macKey);
            this.cmac = cipher.encrypt(data, CryptoMode.CBC, AlignMode.NONE, null);
            data.set(1, 2);
            this.rmac = cipher.encrypt(data, CryptoMode.CBC, AlignMode.NONE, null);
            data.set(1, 130);
            cipher.setKey(encKey);
            this.enc = cipher.encrypt(data, CryptoMode.CBC, AlignMode.NONE, null);
            data.set(1, 129);
            cipher.setKey(dekKey);
            this.dek = cipher.encrypt(data, CryptoMode.CBC, AlignMode.NONE, null);
            this.skdMethod = "GP";
        }

        public static SessionKeys Derive(String skdMethod, Binary baseKey, Binary keyDiversData, Binary ssc) {
            Binary cardEncKey = Binary.Bin();
            Binary cardMacKey = Binary.Bin();
            Binary cardDekKey = Binary.Bin();
            GP_SM.DeriveSMKeys(skdMethod, baseKey, keyDiversData, cardEncKey, cardMacKey, cardDekKey);
            SessionKeys sk = new SessionKeys(cardEncKey, cardMacKey, cardDekKey, ssc);
            sk.skdMethod = skdMethod;
            return sk;
        }
    }
}

