/*
 * Decompiled with CFR 0.152.
 */
package org.denom.vrcp;

import org.denom.Binary;
import org.denom.Ex;

public class VRAU {
    public static final int ENUM_COMMANDS = -1610612735;
    public static final int STATUS_OK = 0;
    public int index;
    public int answerCode;
    public int status;
    public Binary data = new Binary();

    public VRAU() {
    }

    public VRAU(int index, int answerCode, int status, Binary data) {
        this.index = index;
        this.answerCode = answerCode;
        this.status = status;
        this.data = data.clone();
    }

    public boolean decode(Binary vrau) {
        this.data.clear();
        int size = vrau.size();
        if (size < 16) {
            return false;
        }
        this.index = vrau.getIntBE(0);
        this.answerCode = vrau.getIntBE(4);
        this.status = vrau.getIntBE(8);
        int length = vrau.getIntBE(12);
        if (length != size - 16) {
            return false;
        }
        if (length != 0) {
            this.data = vrau.slice(16, length);
        }
        return true;
    }

    public void encode(Binary vrau) {
        VRAU.encode(this.index, this.answerCode, this.status, this.data, vrau);
    }

    public static void encode(int index, int answerCode, int status, Binary data, Binary vrau) {
        vrau.clear();
        int length = data.size();
        vrau.resize(16 + length);
        vrau.setIntBE(0, index);
        vrau.setIntBE(4, answerCode);
        vrau.setIntBE(8, status);
        vrau.setIntBE(12, length);
        vrau.set(16, data, 0, length);
    }

    public int[] parseEnumCommands() {
        Ex.MUST(this.answerCode == -1610612735, "Wrong VR Answer Code in ENUM COMMANDS");
        Ex.MUST(this.data.size() % 4 == 0, "Incorrect answer in VR command ENUM COMMANDS");
        int[] cmdList = new int[this.data.size() >> 2];
        int offset = 0;
        int i = 0;
        while (offset < this.data.size()) {
            cmdList[i] = this.data.getIntBE(offset);
            offset += 4;
            ++i;
        }
        return cmdList;
    }
}

